package ru.yandex.search.messenger;

public enum SearchPrivacy {
    ALL(0),
    CONTACTS(1),
    NOBODY(2);

    private final int value;
    private final String valueStr;

    SearchPrivacy(final int value) {
        this.value = value;
        this.valueStr = String.valueOf(value);
    }

    public int value() {
        return value;
    }

    public String stringValue() {
        return valueStr;
    }

    public static SearchPrivacy parse(final String policy) {
        if (policy == null) {
            return null;
        }

        try {
            return parse(Integer.parseInt(policy));
        } catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static SearchPrivacy parse(final int policy) {
        if (policy < 0 || policy >= SearchPrivacy.values().length) {
            return null;
        }

        return SearchPrivacy.values()[policy];
    }
}
