package ru.yandex.search.messenger;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.string.CollectionParser;
import ru.yandex.search.prefix.LongPrefix;

public class UserChats implements SearchBackendField {
    public static final CollectionParser<String, Set<String>, Exception> CHATS_SET_PARSER
        = new CollectionParser<>(String::trim, LinkedHashSet::new, '\n');
    public static final UserChats VERSIONS =
        new UserChats("user_chats_versions", FieldType.GLOBAL_STORED);
    public static final UserChats USER_ID =
        new UserChats("user_chats_user_id", FieldType.GLOBAL_STORED);
    public static final UserChats CHATS =
        new UserChats("user_chats", FieldType.GLOBAL_STORED);

    private static final LongPrefix PREFIX = new LongPrefix(1L);

    private final String fieldName;
    private final String stored;
    private final String prefixed;
    private final String global;

    UserChats(final String name, final FieldType fieldType) {
        this.fieldName = name;

        String global = null;
        String prefixed = null;
        String stored = null;
        switch (fieldType) {
            case GLOBAL:
                global = fieldName;
                break;
            case GLOBAL_STORED:
                global = fieldName;
                stored = fieldName;
                break;
            case PREFIXED:
                prefixed = fieldName;
                break;
            case PREFIXED_STORED:
                prefixed = fieldName;
                stored = fieldName;
                break;
            case WITH_PREFIX_ALIAS:
                global = fieldName;
                prefixed = fieldName + "_p";
                break;
            case STORED_WITH_PREFIX_ALIAS:
                global = fieldName;
                stored = fieldName;
                prefixed = fieldName + "_p";
                break;
        }

        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    public static LongPrefix prefix() {
        return PREFIX;
    }

    public static String id(final String userId) {
        return "user_chats_" + userId;
    }

    @Override
    public String stored() {
        return stored;
    }

    @Override
    public String prefixed() {
        return prefixed;
    }

    @Override
    public String global() {
        return global;
    }

    @Override
    public String fieldName() {
        return fieldName;
    }

    public static void appendId(final StringBuilder sb, final String guid) {
        sb.append("user_chats_");
        sb.append(guid);
    }
}
