package ru.yandex.search.messenger;

import java.util.Locale;

public enum UserFields implements SearchBackendField {
    NICKNAME(FieldType.STORED_WITH_PREFIX_ALIAS),
    NICKNAME_TOKENIZED(FieldType.WITH_PREFIX_ALIAS),
    BLACKLISTED_USERS(FieldType.GLOBAL_STORED),
    WHITELISTED_USERS(FieldType.GLOBAL_STORED),
    HIDDEN_PVP_CHATS(FieldType.GLOBAL_STORED),
    DISPLAY_RESTRICTED(FieldType.GLOBAL_STORED),
    SEARCH_PRIVACY(),
    DATA(FieldType.GLOBAL_STORED),
    USER_ID("user_id", "user_id", null, "user_id"),
    CHAT_LAST_MESSAGE_DAY();

    private final String fieldName;
    private final String stored;
    private final String prefixed;
    private final String global;

    UserFields() {
        this.fieldName = "user_" + name().toLowerCase(Locale.ENGLISH);
        this.stored = fieldName;
        this.global = fieldName;
        this.prefixed = null;
    }

    private String defaultFieldName() {
        return "user_" + name().toLowerCase(Locale.ENGLISH);
    }

    UserFields(final FieldType fieldType) {
        this.fieldName = defaultFieldName();

        String global = null;
        String prefixed = null;
        String stored = null;
        switch (fieldType) {
            case GLOBAL:
                global = fieldName;
                break;
            case GLOBAL_STORED:
                global = fieldName;
                stored = fieldName;
                break;
            case PREFIXED:
                prefixed = fieldName;
                break;
            case PREFIXED_STORED:
                prefixed = fieldName;
                stored = fieldName;
                break;
            case WITH_PREFIX_ALIAS:
                global = fieldName;
                prefixed = fieldName + "_p";
                break;
            case STORED_WITH_PREFIX_ALIAS:
                global = fieldName;
                stored = fieldName;
                prefixed = fieldName + "_p";
                break;
        }

        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    UserFields(final String fieldName) {
        this(fieldName, fieldName);
    }

    UserFields(final String fieldName, final String global) {
        this.fieldName = fieldName;
        this.global = global;
        this.stored = null;
        this.prefixed = null;
    }

    UserFields(final String fieldName, final String prefixed, final String global) {
        this.fieldName = fieldName;
        this.prefixed = prefixed;
        this.global = global;
        this.stored = null;
    }

    UserFields(
        final String fieldName,
        final String stored,
        final String prefixed,
        final String global)
    {
        this.fieldName = fieldName;
        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    @Override
    public String stored() {
        return stored;
    }

    @Override
    public String prefixed() {
        return prefixed;
    }

    @Override
    public String global() {
        return global;
    }

    @Override
    public String fieldName() {
        return fieldName;
    }

    public static void appendId(final StringBuilder sb, final String guid, final String orgId) {
        sb.append("user_");
        sb.append(guid);
        sb.append('@');
        sb.append(orgId);
    }

    public static String id(final String guid, final String orgId) {
        final StringBuilder sb =
            new StringBuilder(guid.length() + orgId.length() + 6);

        appendId(sb, guid, orgId);
        return sb.toString();
    }
}
