package ru.yandex.search.messenger.proxy;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.messenger.MessageFields;
import ru.yandex.search.prefix.StringPrefix;

public class Drop26NamespaceChatHistory implements ProxyRequestHandler {
    private final Moxy moxy;
    private final AsyncClient storeClient;

    public Drop26NamespaceChatHistory(final Moxy moxy) throws IOException {
        this.moxy = moxy;
        HttpTargetConfigBuilder builder = new HttpTargetConfigBuilder(moxy.config().producerClientConfig());
        builder.timeout((int) TimeUnit.SECONDS.toMillis(5));
        try {
            this.storeClient = moxy.client("ProducerStoreClient", builder.build());
        } catch (ConfigException ce) {
            throw new IOException(ce);
        }
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        CgiParams params = session.params();
        String chatId = params.getString("chat-id");

        String[] parts = chatId.split("/");
        if (parts.length != 3 || !"26".equalsIgnoreCase(parts[1])) {
            throw new BadRequestException("Wrong namespace or chatId");
        }

        User user = new User(moxy.config().messagesService(), new StringPrefix(chatId));
        QueryConstructor qc = new QueryConstructor("/delete?26namespace");
        qc.append("service", user.service());
        qc.append("prefix", user.prefix().toString());
        qc.append("text", MessageFields.CHAT_ID.global() + ":" + chatId);

        BasicAsyncRequestProducerGenerator generator =
            new BasicAsyncRequestProducerGenerator(qc.toString());
        generator.addHeader(YandexHeaders.ZOO_SHARD_ID, String.valueOf(user.prefix().hash() % SearchMap.SHARDS_COUNT));
        AsyncClient client = storeClient.adjust(session.context());

        client.execute(
            moxy.producerHost(),
            generator,
            EmptyAsyncConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            new Callback(session));
    }

    private static class Callback extends AbstractProxySessionCallback<Object> {
        public Callback(ProxySession session) {
            super(session);
        }

        @Override
        public void completed(Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
