package ru.yandex.search.messenger.proxy;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;

public abstract class ScopeContext<T> {
    protected T requestContext;

    public ScopeContext(
        final ProxySession session,
        final T requestContext)
        throws HttpException
    {
        this.requestContext = requestContext;
    }

    public abstract User user();

    public abstract String service();

    public QueryConstructor query() throws HttpException {
        return createQuery(requestContext);
    }

    public abstract QueryConstructor createQuery(
        final T context)
        throws HttpException;
}

