package ru.yandex.search.messenger.proxy.chatmedia;

import java.util.concurrent.TimeUnit;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.util.string.StringUtils;

public abstract class AbstractChatMediaRequest extends RequestContext {
    public static final long ONE_DAY = TimeUnit.DAYS.toMicros(1);
    public static final int DAYS = 14;

    public AbstractChatMediaRequest(final ChatMediaRequestContext mediaContext) {
        super(mediaContext);
    }

    @Override
    protected QueryConstructor query() throws HttpException {
        QueryConstructor query = new QueryConstructor(
            "/search?json-type=dollar&chat_media=true&IO_PRIO=0"
                + "&get=message_timestamp,message_data,message_hid");
        query.append("collector", "pruning(" + pruningField() + ")");
        query.append("sort", "message_timestamp");
        query.append("force-pruning-group-field", "true");
        query.append("group", "message_timestamp");
        query.append(
            ChatMediaHandler.TEXT,
            searchText().toString());
        query.append(ChatMediaHandler.PREFIX, mediaContext.chatId());
        if (mediaContext.get().size() > 0) {
            query.append(ChatMediaHandler.GET, StringUtils.join(mediaContext.get(), ','));
        }
        return query;
    }

    protected StringBuilder searchText() {
        final StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append('(');
        if (!mediaContext.types().isEmpty()) {
            sb.append("type_p:(");
            sb.append(StringUtils.join(mediaContext.types(), " "));
            sb.append(")");
        }

        if (!mediaContext.flags().isEmpty()) {
            if (!mediaContext.types().isEmpty()) {
                sb.append(" OR ");
            }

            for (String flag: mediaContext.flags()) {
                sb.append('(');
                sb.append(flag);
                sb.append(":1");
                sb.append(" AND NOT type_p:delete_message)");
                sb.append(" OR ");
            }

            sb.setLength(sb.length() - 4);
        }

        if (mediaContext.fieldsFactory() != null && mediaContext.request().hasWords()) {
            sb.append(") AND (");
            mediaContext.request().fieldsQuery(
                sb,
                mediaContext.fieldsFactory());
        }

        sb.append(") AND NOT message_moderation_action_p:(");
        sb.append(
            StringUtils.join(mediaContext.excludeModerationActions(), ' '));
        sb.append(") AND (message_hid:0 OR message_forwarded:true)");
        sb.append(')');
        return sb;
    }

    protected abstract String pruningField();
}
