package ru.yandex.search.messenger.proxy.chatmedia;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.QueryConstructor;

public class NextAllFetchAndFilterRequest extends AbstractChatMediaRequest {
    public NextAllFetchAndFilterRequest(final ChatMediaRequestContext mediaContext) {
        super(mediaContext);
    }

    @Override
    protected QueryConstructor query() throws HttpException {
        QueryConstructor qc = super.query();
        qc.append("asc", "true");
        qc.append("length", Integer.toString(mediaContext.next() + 2));
        qc.append("postfilter", "message_timestamp >= " + (mediaContext.near() + 1));
        return qc;
    }

    @Override
    protected String pruningField() {
        return "message_hour_p";
    }
}
