package ru.yandex.search.messenger.proxy.chatmedia;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.QueryConstructor;

public class NextGuessRequest extends AbstractChatMediaRequest {
    public NextGuessRequest(
        final ChatMediaRequestContext mediaContext)
    {
        super(mediaContext);
    }

    @Override
    protected QueryConstructor query() throws HttpException {
        QueryConstructor qc = super.query();
        qc.append("asc", "true");
        qc.append("length", Integer.toString(mediaContext.next() + 2));
        long threshold = mediaContext.near();
        if (mediaContext.clearTs() > 0) {
            threshold = Math.max(threshold, mediaContext.clearTs() + 1);
        }
        qc.append("postfilter", "message_timestamp >= " + threshold);
        return qc;
    }

    @Override
    protected StringBuilder searchText() {
        StringBuilder sb = super.searchText();
        sb.append(" AND message_day_p:(");
        long day = mediaContext.near();
        if (mediaContext.clearTs() > 0 && mediaContext.near() <= mediaContext.clearTs()) {
            day = mediaContext.clearTs() + 1;
        }
        for (int i = 0; i <= DAYS; i++) {
            sb.append(day);
            sb.append(' ');
            day += ONE_DAY;
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb;
    }

    @Override
    protected String pruningField() {
        return "message_hour_p";
    }
}
