package ru.yandex.search.messenger.proxy.chatmedia;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.QueryConstructor;

class NextRequest extends AbstractChatMediaRequest {
    NextRequest(final ChatMediaRequestContext mediaContext) {
        super(mediaContext);
    }

    @Override
    protected QueryConstructor query() throws HttpException {
        QueryConstructor query = super.query();
        query.append("asc", "true");
        query.append("length", Integer.toString(mediaContext.next() + 2));
        return query;
    }

    @Override
    protected StringBuilder searchText() {
        StringBuilder sb = super.searchText();
        sb.append(" AND message_timestamp_p:[");
        long startTs = mediaContext.near();
        if (mediaContext.clearTs() >= startTs) {
            startTs = mediaContext.clearTs() + 1;
        }
        sb.append(startTs);
        sb.append(" TO 99999999999999999999]");
        return sb;
    }

    @Override
    protected String pruningField() {
        return "message_day_p";
    }
}
