package ru.yandex.search.messenger.proxy.chatmedia;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.QueryConstructor;

public class PrevGuessRequest extends AbstractChatMediaRequest {
    public PrevGuessRequest(final ChatMediaRequestContext mediaContext) {
        super(mediaContext);
    }

    @Override
    protected QueryConstructor query() throws HttpException {
        QueryConstructor qc = super.query();
        qc.append("length", Integer.toString(mediaContext.prev() + 2));
        long threshold;
        if (mediaContext.next() > 0) {
            threshold = mediaContext.near() - 1;
        } else {
            threshold = mediaContext.near();
        }
        qc.append("postfilter", "message_timestamp <= " + threshold);
        if (mediaContext.clearTs() > 0) {
            qc.append("postfilter", "message_timestamp >= " + (mediaContext.clearTs() + 1));
        }
        return qc;
    }

    @Override
    protected StringBuilder searchText() {
        StringBuilder sb = super.searchText();
        sb.append(" AND message_day_p:(");
        long day = mediaContext.near();
        for (int i = 0; i <= DAYS; i++) {
            sb.append(day);
            sb.append(' ');
            day -= ONE_DAY;
            if (mediaContext.clearTs() > 0 && day < mediaContext.clearTs()) {
                break;
            }
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb;
    }

    @Override
    protected String pruningField() {
        return "message_hour_p";
    }
}
