package ru.yandex.search.messenger.proxy.chatmedia;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.QueryConstructor;

class PrevRequest extends AbstractChatMediaRequest {
    PrevRequest(final ChatMediaRequestContext mediaContext) {
        super(mediaContext);
    }

    @Override
    protected QueryConstructor query() throws HttpException {
        QueryConstructor query = super.query();
        query.append("length", Integer.toString(mediaContext.prev() + 1));
        return query;
    }

    @Override
    protected StringBuilder searchText() {
        StringBuilder sb = super.searchText();
        sb.append(" AND message_timestamp_p:[");
        long startTs = 0;
        if (mediaContext.clearTs() > 0) {
            startTs = mediaContext.clearTs() + 1;
        }
        sb.append(startTs);
        sb.append(" TO ");
        // next and prev request, try to not overlap when both request present
        // if missing one of them - we sould reajust
        if (mediaContext.next() > 0) {
            sb.append(mediaContext.near() - 1);
        } else {
            sb.append(mediaContext.near());
        }
        sb.append("]");
        return sb;
    }

    @Override
    protected String pruningField() {
        return "message_day_p";
    }
}
