package ru.yandex.search.messenger.proxy.chatmedia;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;

abstract class RequestContext {
    protected final ChatMediaRequestContext mediaContext;

    RequestContext(final ChatMediaRequestContext mediaContext) {
        this.mediaContext = mediaContext;
    }

    protected abstract QueryConstructor query() throws HttpException;

    protected User user() {
        return mediaContext.user();
    }

    protected boolean allowLaggingHosts() {
        return mediaContext.allowLaggingHosts();
    }

    protected long failoverDelay() {
        return mediaContext.failoverDelay();
    }

    protected boolean localityShuffle() {
        return mediaContext.localityShuffle();
    }

    protected String service() {
        return user().service();
    }
}
