package ru.yandex.search.messenger.proxy.config;

import ru.yandex.erratum.ErratumConfig;
import ru.yandex.erratum.ErratumConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractMoxyConfigBuilder
    <T extends AbstractMoxyConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements MoxyConfig
{
    private ErratumConfigBuilder misspellConfig;
    private HttpHostConfigBuilder mssngrRouterConfig;
    private HttpTargetConfigBuilder moxyConfig;
    private TopPostsConfigBuilder topPostConfig;
    private String chatsService;
    private String v2ChatsService;
    private String messagesService;
    private String usersService;
    private String v2UsersService;
    private long chatsSuggestFailoverDelay;
    private long usersSuggestFailoverDelay;
    private long messagesSuggestFailoverDelay;
    private long geoFailoverDelay;
    private long topPostsFailoverDelay;
    private long recentsFailoverDelay;
    private boolean recentsCache;
    private boolean chatsSuggestLocalityShuffle;
    private boolean usersSuggestLocalityShuffle;
    private boolean messagesSuggestLocalityShuffle;
    private boolean geoLocalityShuffle;
    private boolean topPostsLocalityShuffle;
    private boolean recentsLocalityShuffle;
    private RecommendedChannelsConfigBuilder recommendedChannelsConfig;
    private long topPostsCacheTime;
    private long cmntCacheTime;

    protected AbstractMoxyConfigBuilder(
        final MoxyConfig config)
        throws ConfigException
    {
        super(config);
        misspellConfig(config.misspellConfig());
        mssngrRouterConfig(config.mssngrRouterConfig());
        moxyConfig(config.moxyConfig());
        recommendedChannelsConfig(config.recommendedChannelsConfig());
        chatsService = config.chatsService();
        messagesService = config.messagesService();
        usersService = config.usersService();
        v2UsersService(config.v2UsersService());
        v2ChatsService(config.v2ChatsService());
        chatsSuggestFailoverDelay = config.chatsSuggestFailoverDelay();
        usersSuggestFailoverDelay = config.usersSuggestFailoverDelay();
        messagesSuggestFailoverDelay = config.messagesSuggestFailoverDelay();
        geoFailoverDelay = config.geoFailoverDelay();
        topPostsFailoverDelay = config.topPostsFailoverDelay();
        chatsSuggestLocalityShuffle = config.chatsSuggestLocalityShuffle();
        usersSuggestLocalityShuffle = config.usersSuggestLocalityShuffle();
        messagesSuggestLocalityShuffle =
            config.messagesSuggestLocalityShuffle();
        geoLocalityShuffle = config.geoLocalityShuffle();
        topPostsLocalityShuffle = config.topPostsLocalityShuffle();
        topPostsCacheTime = config.topPostsCacheTime();
        cmntCacheTime = config.cmntCacheTime();
        recentsFailoverDelay = config.recentsFailoverDelay();
        recentsLocalityShuffle = config.recentsLocalityShuffle();
        recentsCache = config.recentsCache();

        topPostConfig(config.topPostConfig());
    }

    protected AbstractMoxyConfigBuilder(
        final IniConfig config,
        final MoxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig misspellConfig = config.sectionOrNull("misspell");
        if (misspellConfig == null) {
            misspellConfig(defaults.misspellConfig());
        } else if (defaults.misspellConfig() == null) {
            this.misspellConfig =
                new ErratumConfigBuilder(misspellConfig);
        } else {
            this.misspellConfig =
                new ErratumConfigBuilder(
                    misspellConfig,
                    defaults.misspellConfig());
        }

        IniConfig topPostSection = config.section("top-posts");
        if (topPostSection != null) {
            topPostConfig =
                new TopPostsConfigBuilder(
                    topPostSection,
                    defaults.topPostConfig());
        } else {
            topPostConfig =
                new TopPostsConfigBuilder(defaults.topPostConfig());
        }

        mssngrRouterConfig =
            new HttpHostConfigBuilder(
                config.section("router"),
                defaults.mssngrRouterConfig());

        chatsService = config.getString(
            "chats-service",
            defaults.chatsService());
        messagesService = config.getString(
            "messages-service",
            defaults.messagesService());
        usersService = config.getString(
            "users-service",
            defaults.usersService());
        v2ChatsService = config.getString(
            "v2-org-chat-service-name",
            defaults.v2ChatsService());
        v2UsersService = config.getString(
            "v2-org-user-service-name",
            defaults.v2UsersService());

        chatsSuggestFailoverDelay = config.getLongDuration(
            "chats-suggest-failover-delay",
            defaults.chatsSuggestFailoverDelay());

        usersSuggestFailoverDelay = config.getLongDuration(
            "users-suggest-failover-delay",
            defaults.usersSuggestFailoverDelay());

        messagesSuggestFailoverDelay = config.getLongDuration(
            "messages-suggest-failover-delay",
            defaults.messagesSuggestFailoverDelay());

        geoFailoverDelay = config.getLongDuration(
            "geo-search-failover-delay",
            defaults.geoFailoverDelay());

        topPostsFailoverDelay = config.getLongDuration(
            "top-posts-failover-delay",
            defaults.topPostsFailoverDelay());

        chatsSuggestLocalityShuffle = config.getBoolean(
            "chats-suggest-locality-shuffle",
            defaults.chatsSuggestLocalityShuffle());

        usersSuggestLocalityShuffle = config.getBoolean(
            "users-suggest-locality-shuffle",
            defaults.usersSuggestLocalityShuffle());

        messagesSuggestLocalityShuffle = config.getBoolean(
            "messages-suggest-locality-shuffle",
            defaults.messagesSuggestLocalityShuffle());

        geoLocalityShuffle = config.getBoolean(
            "geo-search-locality-shuffle",
            defaults.geoLocalityShuffle());

        recentsLocalityShuffle = config.getBoolean(
            "recents-locality-shuffle",
            defaults.recentsLocalityShuffle());

        recentsCache = config.getBoolean(
            "recents-cache",
            defaults.recentsCache());

        recentsFailoverDelay = config.getLongDuration(
            "recents-failover-delay",
            defaults.recentsFailoverDelay());

        topPostsLocalityShuffle = config.getBoolean(
            "top-posts-locality-shuffle",
            defaults.topPostsLocalityShuffle());
        topPostsCacheTime = config.getLongDuration(
            "top-posts-cache-time",
            defaults.topPostsCacheTime());

        cmntCacheTime = config.getLongDuration(
            "cmnt-cache-time",
            defaults.cmntCacheTime());

        IniConfig recChannelsSection = config.sectionOrNull("recommended-channels");
        if (recChannelsSection != null) {
            recommendedChannelsConfig
                = new RecommendedChannelsConfigBuilder(
                    recChannelsSection,
                defaults.recommendedChannelsConfig());
        } else {
            recommendedChannelsConfig =
                new RecommendedChannelsConfigBuilder(
                    defaults.recommendedChannelsConfig());
        }

        IniConfig moxySection = config.sectionOrNull("moxy-client");
        if (moxySection != null) {
            moxyConfig = new HttpTargetConfigBuilder(moxySection, defaults.moxyConfig());
        } else {
            moxyConfig(defaults.moxyConfig());
        }
    }

    @Override
    public ErratumConfigBuilder misspellConfig() {
        return misspellConfig;
    }

    public T misspellConfig(final ErratumConfig misspellConfig) {
        if (misspellConfig == null) {
            this.misspellConfig = null;
        } else {
            this.misspellConfig = new ErratumConfigBuilder(misspellConfig);
        }
        return self();
    }

    @Override
    public String chatsService() {
        return chatsService;
    }

    public T chatsService(final String chatsService) {
        this.chatsService = chatsService;
        return self();
    }

    @Override
    public String messagesService() {
        return messagesService;
    }

    public T messagesService(final String messagesService) {
        this.messagesService = messagesService;
        return self();
    }

    @Override
    public String usersService() {
        return usersService;
    }

    public T usersService(final String usersService) {
        this.usersService = usersService;
        return self();
    }

    @Override
    public HttpHostConfigBuilder mssngrRouterConfig() {
        return mssngrRouterConfig;
    }

    public T mssngrRouterConfig(final HttpHostConfig config) {
        this.mssngrRouterConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public long chatsSuggestFailoverDelay() {
        return chatsSuggestFailoverDelay;
    }

    @Override
    public long usersSuggestFailoverDelay() {
        return usersSuggestFailoverDelay;
    }

    @Override
    public long messagesSuggestFailoverDelay() {
        return messagesSuggestFailoverDelay;
    }

    @Override
    public boolean chatsSuggestLocalityShuffle() {
        return chatsSuggestLocalityShuffle;
    }

    @Override
    public boolean usersSuggestLocalityShuffle() {
        return usersSuggestLocalityShuffle;
    }

    @Override
    public boolean messagesSuggestLocalityShuffle() {
        return messagesSuggestLocalityShuffle;
    }

    @Override
    public long geoFailoverDelay() {
        return geoFailoverDelay;
    }

    @Override
    public long topPostsFailoverDelay() {
        return topPostsFailoverDelay;
    }

    @Override
    public boolean geoLocalityShuffle() {
        return geoLocalityShuffle;
    }

    @Override
    public boolean topPostsLocalityShuffle() {
        return topPostsLocalityShuffle;
    }

    @Override
    public long topPostsCacheTime() {
        return topPostsCacheTime;
    }

    @Override
    public long cmntCacheTime() {
        return cmntCacheTime;
    }

    public void copyTo(final AbstractMoxyConfigBuilder<?> other) {
        copyTo((AbstractUniversalSearchProxyConfigBuilder<?>) other);
    }

    public T moxyConfig(final HttpTargetConfig config) {
        this.moxyConfig = new HttpTargetConfigBuilder(config);
        return self();
    }

    @Override
    public HttpTargetConfigBuilder moxyConfig() {
        return moxyConfig;
    }

    public T recentsLocalityShuffle(boolean recentsLocalityShuffle) {
        this.recentsLocalityShuffle = recentsLocalityShuffle;
        return self();
    }

    @Override
    public boolean recentsLocalityShuffle() {
        return recentsLocalityShuffle;
    }

    @Override
    public long recentsFailoverDelay() {
        return recentsFailoverDelay;
    }

    public T recentsFailoverDelay(long recentsFailoverDelay) {
        this.recentsFailoverDelay = recentsFailoverDelay;
        return self();
    }

    @Override
    public TopPostsConfigBuilder topPostConfig() {
        return topPostConfig;
    }

    public T topPostConfig(
        final TopPostsConfig topPostConfig)
    {
        this.topPostConfig = new TopPostsConfigBuilder(topPostConfig);
        return self();
    }

    @Override
    public boolean recentsCache() {
        return recentsCache;
    }

    public T recentsCache(final boolean recentsCache) {
        this.recentsCache = recentsCache;
        return self();
    }

    @Override
    public RecommendedChannelsConfigBuilder recommendedChannelsConfig() {
        return recommendedChannelsConfig;
    }

    public T recommendedChannelsConfig(
        final RecommendedChannelsConfig config)
    {
        this.recommendedChannelsConfig
            = new RecommendedChannelsConfigBuilder(config);

        return self();
    }

    @Override
    public String v2ChatsService() {
        return v2ChatsService;
    }

    public T v2ChatsService(final String v2ChatsService) {
        this.v2ChatsService = v2ChatsService;
        return self();
    }

    @Override
    public String v2UsersService() {
        return v2UsersService;
    }

    public T v2UsersService(final String v2UsersService) {
        this.v2UsersService = v2UsersService;
        return self();
    }
}
