package ru.yandex.search.messenger.proxy.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;

public abstract class AbstractRecommendedChannelsConfigBuilder
    <T extends AbstractRecommendedChannelsConfigBuilder<T>>
     implements RecommendedChannelsConfig
{
    private boolean cacheEnabled;
    private Set<String> goodVerdicts;

    protected AbstractRecommendedChannelsConfigBuilder(final RecommendedChannelsConfig config) {
        cacheEnabled(config.cacheEnabled());
        goodVerdicts(config.goodVerdicts());
    }

    protected AbstractRecommendedChannelsConfigBuilder(
        final IniConfig config,
        final RecommendedChannelsConfig defaults)
        throws ConfigException
    {
        this.cacheEnabled =
            config.getBoolean("cache-enabled", defaults.cacheEnabled());
        this.goodVerdicts =
            config.get(
                "good-verdicts",
                defaults.goodVerdicts(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new));
    }

    @Override()
    public boolean cacheEnabled() {
        return cacheEnabled;
    }

    public T cacheEnabled(final boolean value) {
        this.cacheEnabled = value;
        return self();
    }

    @Override()
    public Set<String> goodVerdicts() {
        return goodVerdicts;
    }

    public T goodVerdicts(final Set<String> value) {
        this.goodVerdicts = new LinkedHashSet<String>(
            value);
        return self();
    }

    public abstract T self();
}
