package ru.yandex.search.messenger.proxy.config;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractTopPostsConfigBuilder
    <T extends AbstractTopPostsConfigBuilder<T>>
     implements TopPostsConfig
{
    private long updateInterval;
    private boolean loadOnStartup;
    private int startupAfterNumberFailures;
    private Collection<String> cachedParams;
    private File hardcodedChannels;

    protected AbstractTopPostsConfigBuilder(final TopPostsConfig config) {
        updateInterval(config.updateInterval());
        loadOnStartup(config.loadOnStartup());
        startupAfterNumberFailures(config.startupAfterNumberFailures());
        cachedParams(config.cachedParams());
        hardcodedChannels(config.hardcodedChannels());
    }

    protected AbstractTopPostsConfigBuilder(
        final IniConfig config,
        final TopPostsConfig defaults)
        throws ConfigException
    {
        this.updateInterval =
            config.getLongDuration("update-interval", defaults.updateInterval());
        this.loadOnStartup =
            config.getBoolean("load-on-startup", defaults.loadOnStartup());
        this.hardcodedChannels =
            config.getInputFile("hardcoded-channels", defaults.hardcodedChannels());

        this.startupAfterNumberFailures =
            config.getInt(
                "startup-after-number-failures",
                defaults.startupAfterNumberFailures());
        this.cachedParams =
            config.get(
                "cached-params",
                defaults.cachedParams(),
                new CollectionParser<>(NonEmptyValidator.TRIMMED, LinkedHashSet::new, '|'));
    }

    @Override()
    public long updateInterval() {
        return updateInterval;
    }

    public T updateInterval(final long value) {
        this.updateInterval = value;
        return self();
    }

    @Override()
    public boolean loadOnStartup() {
        return loadOnStartup;
    }

    public T loadOnStartup(final boolean value) {
        this.loadOnStartup = value;
        return self();
    }

    @Override()
    public int startupAfterNumberFailures() {
        return startupAfterNumberFailures;
    }

    public T startupAfterNumberFailures(final int value) {
        this.startupAfterNumberFailures = value;
        return self();
    }

    @Override()
    public Collection<String> cachedParams() {
        return cachedParams;
    }

    public T cachedParams(final Collection<String> value) {
        this.cachedParams = value;
        return self();
    }

    @Override
    public File hardcodedChannels() {
        return hardcodedChannels;
    }

    public T hardcodedChannels(final File hardcodedChannels) {
        this.hardcodedChannels = hardcodedChannels;
        return self();
    }

    public abstract T self();
}
