package ru.yandex.search.messenger.proxy.config;

import ru.yandex.erratum.ErratumConfig;
import ru.yandex.erratum.ImmutableErratumConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableMoxyConfig
    extends ImmutableUniversalSearchProxyConfig
    implements MoxyConfig
{
    private final ImmutableErratumConfig misspellConfig;
    private final ImmutableHttpHostConfig mssngrRouterConfig;
    private final ImmutableHttpTargetConfig moxyConfig;
    private final ImmutableTopPostsConfig topPostConfig;
    private final ImmutableRecommendedChannelsConfig recommendedChannelsConfig;
    private final String chatsService;
    private final String messagesService;
    private final String usersService;
    private final String v2ChatsService;
    private final String v2UsersService;
    private final long chatsSuggestFailoverDelay;
    private final long usersSuggestFailoverDelay;
    private final long messagesSuggestFailoverDelay;
    private final long geoFailoverDelay;
    private final long topPostsFailoverDelay;
    private final boolean chatsSuggestLocalityShuffle;
    private final boolean usersSuggestLocalityShuffle;
    private final boolean messagesSuggestLocalityShuffle;
    private final boolean geoLocalityShuffle;
    private final boolean topPostsLocalityShuffle;
    private final long topPostsCacheTime;
    private final long cmntCacheTime;
    private final long recentsFailoverDelay;
    private final boolean recentsLocalityShuffle;
    private final boolean recentsCache;

    public ImmutableMoxyConfig(
        final MoxyConfig config)
        throws ConfigException
    {
        super(config);
        ErratumConfig misspellConfig = config.misspellConfig();
        if (misspellConfig == null) {
            this.misspellConfig = null;
        } else {
            this.misspellConfig = new ImmutableErratumConfig(misspellConfig);
        }
        mssngrRouterConfig = new ImmutableHttpHostConfig(config.mssngrRouterConfig());
        chatsService = config.chatsService();
        messagesService = config.messagesService();
        usersService = config.usersService();
        v2UsersService = config.v2UsersService();
        v2ChatsService = config.v2ChatsService();
        chatsSuggestFailoverDelay = config.chatsSuggestFailoverDelay();
        usersSuggestFailoverDelay = config.usersSuggestFailoverDelay();
        messagesSuggestFailoverDelay = config.messagesSuggestFailoverDelay();
        geoFailoverDelay = config.geoFailoverDelay();
        topPostsFailoverDelay = config.topPostsFailoverDelay();
        chatsSuggestLocalityShuffle = config.chatsSuggestLocalityShuffle();
        usersSuggestLocalityShuffle = config.usersSuggestLocalityShuffle();
        messagesSuggestLocalityShuffle =
            config.messagesSuggestLocalityShuffle();
        geoLocalityShuffle = config.geoLocalityShuffle();
        topPostsLocalityShuffle = config.topPostsLocalityShuffle();
        topPostsCacheTime = config.topPostsCacheTime();
        cmntCacheTime = config.cmntCacheTime();
        moxyConfig = new ImmutableHttpTargetConfig(config.moxyConfig());
        recommendedChannelsConfig = new ImmutableRecommendedChannelsConfig(config.recommendedChannelsConfig());
        recentsFailoverDelay = config.recentsFailoverDelay();
        recentsLocalityShuffle = config.recentsLocalityShuffle();
        recentsCache = config.recentsCache();
        topPostConfig = new TopPostsConfigBuilder(config.topPostConfig()).build();
    }

    @Override
    public ImmutableErratumConfig misspellConfig() {
        return misspellConfig;
    }

    @Override
    public String chatsService() {
        return chatsService;
    }

    @Override
    public String messagesService() {
        return messagesService;
    }

    @Override
    public String usersService() {
        return usersService;
    }

    @Override
    public long chatsSuggestFailoverDelay() {
        return chatsSuggestFailoverDelay;
    }

    @Override
    public long usersSuggestFailoverDelay() {
        return usersSuggestFailoverDelay;
    }

    @Override
    public long messagesSuggestFailoverDelay() {
        return messagesSuggestFailoverDelay;
    }

    @Override
    public boolean chatsSuggestLocalityShuffle() {
        return chatsSuggestLocalityShuffle;
    }

    @Override
    public boolean usersSuggestLocalityShuffle() {
        return usersSuggestLocalityShuffle;
    }

    @Override
    public boolean messagesSuggestLocalityShuffle() {
        return messagesSuggestLocalityShuffle;
    }

    @Override
    public long geoFailoverDelay() {
        return geoFailoverDelay;
    }

    @Override
    public long topPostsFailoverDelay() {
        return topPostsFailoverDelay;
    }

    @Override
    public boolean geoLocalityShuffle() {
        return geoLocalityShuffle;
    }

    @Override
    public boolean topPostsLocalityShuffle() {
        return topPostsLocalityShuffle;
    }

    @Override
    public long topPostsCacheTime() {
        return topPostsCacheTime;
    }

    @Override
    public long cmntCacheTime() {
        return cmntCacheTime;
    }

    @Override
    public ImmutableHttpHostConfig mssngrRouterConfig() {
        return mssngrRouterConfig;
    }

    @Override
    public ImmutableHttpTargetConfig moxyConfig() {
        return moxyConfig;
    }

    @Override
    public long recentsFailoverDelay() {
        return recentsFailoverDelay;
    }

    @Override
    public boolean recentsLocalityShuffle() {
        return recentsLocalityShuffle;
    }

    @Override
    public ImmutableTopPostsConfig topPostConfig() {
        return topPostConfig;
    }

    @Override
    public boolean recentsCache() {
        return recentsCache;
    }

    @Override
    public String v2ChatsService() {
        return v2ChatsService;
    }

    @Override
    public String v2UsersService() {
        return v2UsersService;
    }

    @Override
    public ImmutableRecommendedChannelsConfig recommendedChannelsConfig() {
        return recommendedChannelsConfig;
    }
}
