package ru.yandex.search.messenger.proxy.config;

import java.util.Collections;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableRecommendedChannelsConfig
     implements RecommendedChannelsConfig
{
    private final boolean cacheEnabled;
    private final Set<String> goodVerdicts;

    public ImmutableRecommendedChannelsConfig(
        final RecommendedChannelsConfig config)
        throws ConfigException
    {
        this.cacheEnabled = config.cacheEnabled();
        this.goodVerdicts = Collections.unmodifiableSet(config.goodVerdicts());
    }

    @Override
    public boolean cacheEnabled() {
        return cacheEnabled;
    }

    @Override
    public Set<String> goodVerdicts() {
        return goodVerdicts;
    }
}
