package ru.yandex.search.messenger.proxy.config;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

import ru.yandex.parser.config.ConfigException;

public class ImmutableTopPostsConfig
     implements TopPostsConfig
{
    private final long updateInterval;
    private final boolean loadOnStartup;
    private final File hardcodedChannels;
    private final int startupAfterNumberFailures;
    private final Collection<String> cachedParams;

    public ImmutableTopPostsConfig(
        final TopPostsConfig config)
        throws ConfigException
    {
        this.updateInterval = config.updateInterval();
        this.loadOnStartup = config.loadOnStartup();
        this.startupAfterNumberFailures = config.startupAfterNumberFailures();
        this.cachedParams =
            Collections.unmodifiableSet(
                new LinkedHashSet<>(config.cachedParams()));
        this.hardcodedChannels = config.hardcodedChannels();
    }

    @Override
    public long updateInterval() {
        return updateInterval;
    }

    @Override
    public boolean loadOnStartup() {
        return loadOnStartup;
    }

    @Override
    public int startupAfterNumberFailures() {
        return startupAfterNumberFailures;
    }

    @Override
    public Collection<String> cachedParams() {
        return cachedParams;
    }

    @Override
    public File hardcodedChannels() {
        return hardcodedChannels;
    }
}
