package ru.yandex.search.messenger.proxy.config;

import ru.yandex.erratum.ErratumConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface MoxyConfig extends UniversalSearchProxyConfig {
    ErratumConfig misspellConfig();

    HttpHostConfig mssngrRouterConfig();

    HttpTargetConfig moxyConfig();

    TopPostsConfig topPostConfig();

    String chatsService();

    String v2ChatsService();

    String messagesService();

    String usersService();

    String v2UsersService();

    long chatsSuggestFailoverDelay();

    long usersSuggestFailoverDelay();

    long messagesSuggestFailoverDelay();

    boolean chatsSuggestLocalityShuffle();

    boolean usersSuggestLocalityShuffle();

    boolean messagesSuggestLocalityShuffle();

    long geoFailoverDelay();

    boolean geoLocalityShuffle();

    long topPostsFailoverDelay();

    boolean topPostsLocalityShuffle();

    long recentsFailoverDelay();

    boolean recentsLocalityShuffle();

    boolean recentsCache();

    long topPostsCacheTime();

    long cmntCacheTime();

    RecommendedChannelsConfig recommendedChannelsConfig();
}
