package ru.yandex.search.messenger.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MoxyConfigBuilder
    extends AbstractMoxyConfigBuilder<
        MoxyConfigBuilder>
{
    public MoxyConfigBuilder()
        throws ConfigException
    {
        super(MoxyConfigDefaults.INSTANCE);
    }

    public MoxyConfigBuilder(
        final MoxyConfig config)
        throws ConfigException
    {
        super(config);
    }

    public MoxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MoxyConfigDefaults.INSTANCE);
    }

    public MoxyConfigBuilder(
        final IniConfig config,
        final MoxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public MoxyConfigBuilder self() {
        return this;
    }

    public ImmutableMoxyConfig build()
        throws ConfigException
    {
        return new ImmutableMoxyConfig(this);
    }
}
