package ru.yandex.search.messenger.proxy.config;

import ru.yandex.erratum.ErratumConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class MoxyConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements MoxyConfig
{
    public static final MoxyConfigDefaults INSTANCE =
        new MoxyConfigDefaults();

    private static final int DEFAULT_TOP_POSTS_FAILOVER_DELAY = 20;
    private static final int DEFAULT_SUGGEST_FAILOVER_DELAY = 30;
    private static final int DEFAULT_FAILOVER_DELAY = 60;
    private static final int DEFAULT_RECENTS_FAILOVER_DELAY = 150;
    private static final long DEFAULT_TOP_POSTS_CACHE_TIME = 100;
    private static final long DEFAULT_CMNT_CACHE_TIME = 100;

    private static final HttpTargetConfig DEFAULT_MOXY_CONFIG =
        new HttpTargetConfigBuilder().connections(2);

    protected MoxyConfigDefaults() {
    }

    @Override
    public ErratumConfig misspellConfig() {
        return null;
    }

    @Override
    public String chatsService() {
        return "messenger_chats";
    }

    @Override
    public String messagesService() {
        return "messenger_messages";
    }

    @Override
    public String usersService() {
        return "messenger_users";
    }

    @Override
    public String v2UsersService() {
        return "messenger_org_users";
    }

    @Override
    public String v2ChatsService() {
        return "messenger_org_chats";
    }

    @Override
    public long chatsSuggestFailoverDelay() {
        return DEFAULT_SUGGEST_FAILOVER_DELAY;
    }

    @Override
    public long usersSuggestFailoverDelay() {
        return DEFAULT_SUGGEST_FAILOVER_DELAY;
    }

    @Override
    public long messagesSuggestFailoverDelay() {
        return DEFAULT_SUGGEST_FAILOVER_DELAY;
    }

    @Override
    public boolean chatsSuggestLocalityShuffle() {
        return true;
    }

    @Override
    public boolean usersSuggestLocalityShuffle() {
        return true;
    }

    @Override
    public boolean messagesSuggestLocalityShuffle() {
        return true;
    }

    @Override
    public long geoFailoverDelay() {
        return DEFAULT_FAILOVER_DELAY;
    }

    @Override
    public long topPostsFailoverDelay() {
        return DEFAULT_TOP_POSTS_FAILOVER_DELAY;
    }

    @Override
    public boolean geoLocalityShuffle() {
        return true;
    }

    @Override
    public boolean topPostsLocalityShuffle() {
        return true;
    }

    @Override
    public long topPostsCacheTime() {
        return DEFAULT_TOP_POSTS_CACHE_TIME;
    }

    @Override
    public long cmntCacheTime() {
        return DEFAULT_CMNT_CACHE_TIME;
    }

    @Override
    public HttpHostConfig mssngrRouterConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig moxyConfig() {
        return DEFAULT_MOXY_CONFIG;
    }

    @Override
    public long recentsFailoverDelay() {
        return DEFAULT_RECENTS_FAILOVER_DELAY;
    }

    @Override
    public boolean recentsLocalityShuffle() {
        return true;
    }

    @Override
    public TopPostsConfig topPostConfig() {
        return TopPostsConfigDefaults.INSTANCE;
    }

    @Override
    public boolean recentsCache() {
        return false;
    }

    @Override
    public RecommendedChannelsConfig recommendedChannelsConfig() {
        return RecommendedChannelsConfigDefaults.INSTANCE;
    }
}
