package ru.yandex.search.messenger.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class RecommendedChannelsConfigBuilder
     extends AbstractRecommendedChannelsConfigBuilder<RecommendedChannelsConfigBuilder>
{
    public RecommendedChannelsConfigBuilder() {
        this(RecommendedChannelsConfigDefaults.INSTANCE);
    }

    public RecommendedChannelsConfigBuilder(final RecommendedChannelsConfig config) {
        super(config);
    }

    public RecommendedChannelsConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, RecommendedChannelsConfigDefaults.INSTANCE);
    }

    public RecommendedChannelsConfigBuilder(
        final IniConfig config,
        final RecommendedChannelsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableRecommendedChannelsConfig build() throws ConfigException {
        return new ImmutableRecommendedChannelsConfig(
            this);
    }

    @Override
    public RecommendedChannelsConfigBuilder self() {
        return this;
    }
}
