package ru.yandex.search.messenger.proxy.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RecommendedChannelsConfigDefaults
     implements RecommendedChannelsConfig
{
    public static final RecommendedChannelsConfigDefaults INSTANCE =
        new RecommendedChannelsConfigDefaults();
    private static final Set<String> VERDICTS = Collections.unmodifiableSet(
        new LinkedHashSet<>(
            Arrays.asList(
                "ok",
                "ensured_ok",
                "office_ok",
                "text_yang_channel_politics",
                "text_yang_channel_trash")));

    protected RecommendedChannelsConfigDefaults() {
    }

    @Override
    public boolean cacheEnabled() {
        return false;
    }

    @Override
    public Set<String> goodVerdicts() {
        return VERDICTS;
    }
}
