package ru.yandex.search.messenger.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class TopPostsConfigBuilder
     extends AbstractTopPostsConfigBuilder<TopPostsConfigBuilder>
{
    public TopPostsConfigBuilder() {
        this(TopPostsConfigDefaults.INSTANCE);
    }

    public TopPostsConfigBuilder(final TopPostsConfig config) {
        super(config);
    }

    public TopPostsConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, TopPostsConfigDefaults.INSTANCE);
    }

    public TopPostsConfigBuilder(
        final IniConfig config,
        final TopPostsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableTopPostsConfig build() throws ConfigException {
        return new ImmutableTopPostsConfig(
            this);
    }

    @Override
    public TopPostsConfigBuilder self() {
        return this;
    }
}
