package ru.yandex.search.messenger.proxy.forward;

import java.util.Comparator;

public class ForwardComparator implements Comparator<UserOrChatInfo> {
    public static final ForwardComparator INSTANCE = new ForwardComparator();

    @Override
    public int compare(final UserOrChatInfo o1, final UserOrChatInfo o2) {
        int cmp = Integer.compare(o1.dataType().ordinal(), o2.dataType().ordinal());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(o2.lastSeen(), o1.lastSeen());
    }
}
