package ru.yandex.search.messenger.proxy.forward;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

public class ForwardPrinter extends AbstractProxySessionCallback<List<UserOrChatInfo>> {
    private final ForwardRequestContext context;

    public ForwardPrinter(
        final ForwardRequestContext context)
    {
        super(context.session());

        this.context = context;
    }

    @Override
    public void completed(final List<UserOrChatInfo> result) {
        if (result.isEmpty()) {
            context.moxy().emptyForwardResponse();
        }

        result.sort(ForwardComparator.INSTANCE);

        session.logger().info("Result size " + result.size());
        session.connection().setSessionInfo(
                SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
                Integer.toString(result.size()));

        List<UserOrChatInfo> chats = result;
        if (chats.size() > context.length()) {
            chats = chats.subList(0, context.length());
        }

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("result");
            writer.value(chats);
            writer.endObject();
            HttpEntity entity =
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset()));

            session.response(HttpStatus.SC_OK, entity);
        } catch (IOException ioe) {
            failed(ioe);
        }
    }
}
