package ru.yandex.search.messenger.proxy.forward;

import java.io.IOException;

import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class ForwardUserInfo implements JsonValue {
    private final String guid;
    private final JsonMap json;
    private long lastSeen = 0L;

    public ForwardUserInfo(final String guid, final JsonMap json) {
        this.guid = guid;
        this.json = json;
    }

    public String guid() {
        return guid;
    }

    public JsonMap json() {
        return json;
    }

    public ForwardUserInfo lastSeen(final long lastSeen) {
        this.lastSeen = lastSeen;
        json.put("last_online_ts", new JsonLong(lastSeen));
        return this;
    }

    public long lastSeen() {
        return lastSeen;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        json.writeValue(writer);
    }
}
