package ru.yandex.search.messenger.proxy.recchannels;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.search.messenger.proxy.Moxy;
import ru.yandex.stater.MaxAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class CachingRecommendedChannelsHandler
    implements ProxyRequestHandler
{
    private final RecommendedChannelsHandler handler;

    private final TimeFrameQueue<Long> cacheFreshness;

    private final RecommendedChannelsUpdater updater;

    public CachingRecommendedChannelsHandler(final Moxy moxy) throws IOException {
        this.handler = new RecommendedChannelsHandler(moxy);
        updater = new RecommendedChannelsUpdater(moxy);
        cacheFreshness = new TimeFrameQueue<>(moxy.config().metricsTimeFrame());

        moxy.registerStater(
            new PassiveStaterAdapter<>(
                cacheFreshness,
                new NamedStatsAggregatorFactory<>(
                    "recommended-channels-cache-update-lag_axxx",
                    new MaxAggregatorFactory(Long.MAX_VALUE))));
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        boolean skipCache = session.params().getBoolean(
            "skip-cache",
            false);

        if (skipCache) {
            handler.handle(session);
            return;
        }

        RecommendedChannelsPrinter printer = new RecommendedChannelsPrinter(session);

        CachedResponse response = this.updater.channels();
        long lag = System.currentTimeMillis() - response.ts();

        session.logger().info(
            "Channels freshness ms: " + lag);
        cacheFreshness.accept(lag);

        printer.completed(response.chats());
    }
}
