package ru.yandex.search.messenger.proxy.recchannels;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.messenger.proxy.SimpleJsonParser;

public class ChatsCallback
    extends AbstractFilterFutureCallback<JsonObject, List<Chat>>
{
    private final RecommendedChannelsRequestContext context;

    public ChatsCallback(
        final RecommendedChannelsRequestContext context)
        throws HttpException
    {
        super(context.callback());
        this.context = context;
    }

    @Override
    public void completed(final JsonObject result) {
        ArrayList<Chat> chats;
        Set<String> chatIds = new LinkedHashSet<>();
        SimpleJsonParser jsonParser = RecommendedChannelsHandler.getJsonParser();
        try {
            JsonList hits = result.asMap().getList("hitsArray");
            chats = new ArrayList<>(hits.size());
            for (JsonObject o: hits) {
                JsonMap hit = o.asMap();
                String chatId = hit.getString(RecommendedChannelsHandler.CHAT_ID, null);
                if (chatId != null) {
                    context.jsonReformat(hit, jsonParser);
                    chats.add(new Chat(chatId, hit));
                }
            }
        } catch (JsonException e) {
            context.callback().failed(e);
            return;
        } finally {
            RecommendedChannelsHandler.freeJsonParser(jsonParser);
        }

        context.callback().completed(chats);
    }
}
