package ru.yandex.search.messenger.proxy.recchannels;

import org.apache.http.HttpException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.messenger.ChatFields;
import ru.yandex.search.messenger.proxy.Moxy;
import ru.yandex.search.prefix.LongPrefix;

class ChatsRequestContext extends RequestContext {
    private static final long MS_PER_MICRO = 1000;
    private static final long MILLIS_PER_DAY = 86400 * 1000;

    private final User user;

    ChatsRequestContext(
        final Moxy moxy,
        final RecommendedChannelsRequestContext context)
        throws HttpException
    {
        super(context);

        user = new User(moxy.config().chatsService(), new LongPrefix(0));
    }

    @Override
    protected String service() {
        return user.service();
    }

    @Override
    protected QueryConstructor createQuery(
        final RecommendedChannelsRequestContext context)
        throws HttpException
    {
        QueryConstructor query =
            new QueryConstructor(
                "/search?IO_PRIO=0&json-type=dollar"
                + "&sync-searcher=false");
        query.append("get", RecommendedChannelsHandler.GET_FIELDS);
        query.append(RecommendedChannelsHandler.PREFIX, RecommendedChannelsHandler.ZERO);
        query.append("service", user.service());
        if (context.get() != null) {
            query.append("get", context.get());
        }

        StringBuilder textSb = new StringBuilder();
        textSb.append("chat_show_on_morda:true AND ");
        applyTimestampFilter(
            ChatFields.LAST_MESSAGE_DAY.global(),
            textSb,
            7);
        query.append("text", textSb.toString());

        query.append("dp", "equals(" + ChatFields.DESCRIPTION.stored() + ",,  empty_desc)");
        query.append("postfilter", "empty_desc != 1");
        applyTimestampPostFilter(query, ChatFields.LAST_MESSAGE_TIMESTAMP.stored(), 7);
        return query;
    }

    protected static void applyTimestampFilter(
        final String field,
        final StringBuilder sb,
        final int daysDepth)
    {
        long time = System.currentTimeMillis();
        sb.append(field);
        sb.append(":(");
        sb.append(time * MS_PER_MICRO);
        char sep = ' ';
        //we should select daysDepth + 1 days and than trim then by
        //docprocessor to emulate 24h limit
        for (int i = 0; i < daysDepth; i++) {
            sb.append(sep);
            time -= MILLIS_PER_DAY;
            sb.append(time * MS_PER_MICRO);
        }
        sb.append(')');
    }

    protected static void applyTimestampPostFilter(
        final QueryConstructor query,
        final String field,
        final int daysDepth)
        throws BadRequestException
    {
        long timeLimit = System.currentTimeMillis()
            - (daysDepth * MILLIS_PER_DAY);
        timeLimit *= MS_PER_MICRO;
        query.append(
            "postfilter",
            field + " >= " + timeLimit);
    }

    @Override
    protected User user() {
        return user;
    }
}
