package ru.yandex.search.messenger.proxy.recchannels;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.messenger.proxy.Moxy;
import ru.yandex.search.messenger.proxy.SimpleJsonParser;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class RecommendedChannelsHandler implements ProxyRequestHandler {
    public static final int DEFAULT_LENGTH = 20;
    public static final String GET = "get";
    public static final String DP = "dp";
    public static final String PREFIX = "prefix";
    public static final String SERVICE = "service";
    public static final String ZERO = "0";
    public static final String TEXT = "text";
    public static final String HITS_ARRAY = "hitsArray";
    public static final String USER_ID = "user_id";
    public static final String CHAT_ID = "chat_id";
    public static final String USER_DATA = "user_data";
    public static final String CHAT_DATA = "chat_data";
    public static final String CHAT_NAME = "chat_name";
    public static final String CHAT_DESCRIPTION = "chat_description";
    public static final String CHAT_INVITE_HASH = "chat_invite_hash";
    public static final String CHAT_AVATAR_ID = "chat_avatar_id";
    private static final String CHAT_MEMBER_COUNT = "chat_member_count";
    private static final String CHAT_MEMBERS = "chat_members";
    private static final String MESSAGE_DATA = "message_data";
    private static final String MESSAGE_ID = "message_id";
    private static final String MESSAGE_CHAT_ID = "message_chat_id";
    private static final String MESSAGE_SEQ_NO = "message_seq_no";
    private static final String MESSAGE_RCA_DATA = "message_rca_data";
    private static final String MESSAGE_TIMESTAMP = "message_timestamp";
    public static final String GET_FIELDS = CHAT_ID;

    private static final CollectionParser<
        String,
        Set<String>,
        Exception>
        SET_PARSER = new CollectionParser<>(
            String::trim,
//            NonEmptyValidator.INSTANCE,
            LinkedHashSet::new);
    private static final ConcurrentLinkedQueue<SimpleJsonParser> JSON_PARSERS =
        new ConcurrentLinkedQueue<>();
    public static final boolean ALLOW_LAGGING_HOSTS = true;

    protected final Moxy moxy;

    public RecommendedChannelsHandler(final Moxy moxy) {
        this.moxy = moxy;
    }

    public static SimpleJsonParser getJsonParser() {
        SimpleJsonParser parser = JSON_PARSERS.poll();
        if (parser == null) {
            parser = new SimpleJsonParser();
        }
        return parser;
    }

    public static void freeJsonParser(final SimpleJsonParser parser) {
        JSON_PARSERS.add(parser);
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        handle(session, new RecommendedChannelsPrinter(session));
    }

    protected void handle(
        final ProxySession session,
        final FutureCallback<List<Chat>> callback)
        throws HttpException
    {
        RecommendedChannelsRequestContext topContext =
            new RecommendedChannelsRequestContext(session.params(), callback, moxy.config());
        ChatsRequestContext chatsContext =
            new ChatsRequestContext(moxy, topContext);
        sendRequest(
            chatsContext,
            session,
            new ChatsCallback(topContext));
    }

    public void sendRequest(
        final RequestContext context,
        final ProxySession session,
        final FutureCallback<JsonObject> callback)
        throws HttpException
    {
        AsyncClient client = moxy.searchClient().adjust(session.context());
        UniversalSearchProxyRequestContext requestContext =
            new PlainUniversalSearchProxyRequestContext(
                context.user(),
                null,
                context.context.allowLaggingHosts(),
                client,
                session.logger());
        QueryConstructor query = context.query();
        query.append(SERVICE, context.service());
        moxy.sequentialRequest(
            session,
            requestContext,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            context.context.failoverDelay(),
            context.context.localityShuffle(),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            callback);
    }

    @Override
    public String toString() {
        return "Recents handler: "
            + "https://wiki.yandex-team.ru/ps/documentation/"
            + "moxy#recommended-channels";
    }

}

