package ru.yandex.search.messenger.proxy.recchannels;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class RecommendedChannelsPrinter extends AbstractProxySessionCallback<List<Chat>> {
    private final JsonType jsonType;

    public RecommendedChannelsPrinter(final ProxySession session) throws BadRequestException {
        super(session);

        this.jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    @Override
    public void completed(final List<Chat> chats) {
        StringBuilderWriter sbw = new StringBuilderWriter();

        try (JsonWriter writer = jsonType.create(sbw)) {
            writer.startObject();
            writer.key("recommended_channels");
            writer.startArray();
            for (Chat chat : chats) {
                chat.json().writeValue(writer);
            }
            writer.endArray();
            writer.endObject();
            HttpEntity entity =
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset()));
            session.response(HttpStatus.SC_OK, entity);
        } catch (IOException ioe) {
            failed(ioe);
        }
    }
}
