package ru.yandex.search.messenger.proxy.recchannels;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.messenger.proxy.SimpleJsonParser;
import ru.yandex.search.messenger.proxy.config.ImmutableMoxyConfig;

public class RecommendedChannelsRequestContext {
    private static final CollectionParser<
        String,
        Set<String>,
        Exception>
        SET_PARSER = new CollectionParser<>(
        String::trim,
//            NonEmptyValidator.INSTANCE,
        LinkedHashSet::new);
    private static final Set<String> DEFAULT_MESSAGE_TYPES =
        new LinkedHashSet<>(
            Arrays.asList(
                new String[] {
                    "text_message",
//                    "image_message",
                    "gallery_message"}));

    private final int length;
    private final String get;
    private final boolean localityShuffle;
    private final boolean allowLaggingHosts;
    private final long failoverDelay;
    private final ImmutableMoxyConfig config;
    private final int daysDepth;
    private final boolean filterEmptyText;
    private final Collection<String> types;
    private final Collection<String> moderationActions;
    private final FutureCallback<? super List<Chat>> printer;

    public RecommendedChannelsRequestContext(
        final CgiParams params,
        final FutureCallback<? super List<Chat>> printer,
        final ImmutableMoxyConfig config)
        throws HttpException
    {
        this.length = params.getInt("length", RecommendedChannelsHandler.DEFAULT_LENGTH);
        String get =
            params.getString(RecommendedChannelsHandler.GET, null);
        this.get = get;
        this.localityShuffle = params.getBoolean(
            "locality-shuffle",
            config.topPostsLocalityShuffle());
        this.failoverDelay = params.getLong(
            "failover-delay",
            config.topPostsFailoverDelay());
        this.allowLaggingHosts = params.getBoolean(
            "allow-lagging-hosts",
            RecommendedChannelsHandler.ALLOW_LAGGING_HOSTS);
        this.config = config;
        filterEmptyText = true;
        this.types = params.getAll(
            "types",
            DEFAULT_MESSAGE_TYPES,
            SET_PARSER);
        this.moderationActions = params.getAll(
            "moderation-actions",
            Collections.singleton("keep"),
            SET_PARSER);
        this.daysDepth = params.getInt("days-depth", 7);
        this.printer = printer;
    }

    public ImmutableMoxyConfig config() {
        return config;
    }

    public int length() {
        return length;
    }

    public String get() {
        return get;
    }

    public boolean localityShuffle() {
        return localityShuffle;
    }

    public boolean allowLaggingHosts() {
        return allowLaggingHosts;
    }

    public long failoverDelay() {
        return failoverDelay;
    }

    public FutureCallback<? super List<Chat>> callback() {
        return printer;
    }

    public int daysDepth() {
        return daysDepth;
    }

    public boolean filterEmptyText() {
        return filterEmptyText;
    }

    public Collection<String> types() {
        return types;
    }

    public Collection<String> moderationActions() {
        return moderationActions;
    }

    public void jsonReformat(
        final JsonMap doc,
        final SimpleJsonParser jsonParser)
    {
        try {
            String jsonString = doc.get(RecommendedChannelsHandler.CHAT_DATA).asStringOrNull();
            if (jsonString != null) {
                JsonObject obj = jsonParser.parse(jsonString);
                doc.put(RecommendedChannelsHandler.CHAT_DATA, obj);
            }
            jsonString = doc.get(RecommendedChannelsHandler.USER_DATA).asStringOrNull();
            if (jsonString != null) {
                JsonObject obj = jsonParser.parse(jsonString);
                doc.put(RecommendedChannelsHandler.USER_DATA, obj);
            }
        } catch (JsonException e) { // skip, obj is null
        }
    }
}
