package ru.yandex.search.messenger.proxy.recchannels;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;

abstract class RequestContext {
    protected RecommendedChannelsRequestContext context;

    RequestContext(
        final RecommendedChannelsRequestContext context)
        throws HttpException
    {
        this.context = context;
    }

    protected abstract User user();

    protected abstract String service();

    protected QueryConstructor query() throws HttpException {
        return createQuery(context);
    }

    protected abstract QueryConstructor createQuery(
        final RecommendedChannelsRequestContext context)
        throws HttpException;
}
