package ru.yandex.search.messenger.proxy.recents;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.ps.search.messenger.UserFields;

public class ContactPrivacyFilterCallback
    extends AbstractFilterFutureCallback<Set<String>, List<UserInfo>>
{
    private final List<UserInfo> result;
    private final Map<String, String> contacts;
    private final Map<String, JsonMap> userDatas;
    private final Set<String> fromOnline;
    private final Set<String> forClearance;
    private final RecentRequestContext context;

    public ContactPrivacyFilterCallback(
        final FutureCallback<? super List<UserInfo>> callback,
        final List<UserInfo> result,
        final Map<String, String> contacts,
        final Map<String, JsonMap> userDatas,
        final Set<String> fromOnline,
        final Set<String> forClearance,
        final RecentRequestContext context)
    {
        super(callback);
        this.result = result;
        this.contacts = contacts;
        this.userDatas = userDatas;
        this.fromOnline = fromOnline;
        this.forClearance = forClearance;
        this.context = context;
    }

    @Override
    public void completed(final Set<String> success) {
        if (forClearance.size() > 0) {
            if (context.debug()) {
                context.session().logger().info(
                    "After contacts privacy filtration, was: "
                        + forClearance + " success: " + success);
            } else {
                context.session().logger().info(
                    "Privacy contacts clearance, from "
                        + forClearance.size() + " left " + success.size());
            }
        }

        for (String onlineUser: fromOnline) {
            if (!forClearance.contains(onlineUser)
                || (forClearance.contains(onlineUser) && success.contains(onlineUser)))
            {
                JsonMap userData = userDatas.get(onlineUser);
                String contactName = contacts.get(onlineUser);
                if (contactName != null) {
                    userData.put("contact_name", new JsonString(contactName));
                }
                userData.remove(UserFields.HIDDEN_PVP_CHATS.stored());
                userData.remove(UserFields.CLEARED_CHATS.stored());
                userData.remove(UserFields.SEARCH_PRIVACY.stored());
                userData.remove(UserFields.BLACKLISTED_USERS.stored());
                UserInfo info = new UserInfo(onlineUser, userData);
                result.add(info);
            }

            if (result.size() >= context.length()) {
                break;
            }
        }
        callback.completed(result);
    }
}
