package ru.yandex.search.messenger.proxy.recents;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.StringPrefix;

public class ContactsContext extends ScopeContext {
    private final User user;

    public ContactsContext(final RecentRequestContext context)
        throws HttpException
    {
        super(context.session(), context);
        user = new User(context.messagesService(), new StringPrefix(context.guid()));
    }

    @Override
    protected User user() {
        return user;
    }

    @Override
    protected String service() {
        return user.service();
    }

    @Override
    protected QueryConstructor createQuery(
        final RecentRequestContext context)
        throws HttpException
    {
        QueryConstructor query =
            new QueryConstructor(
                "/search?recents_contacts=true&IO_PRIO=0&json-type=dollar");
        query.append("get", "contact_id,contact_name");
        query.append("prefix", context.guid());
        query.append("service", user.service());

        query.append("text", "contact_user_id:" + context.guid());
        query.append("length", context.maxContacts());

        if (context.debug()) {
            context.session().logger().info(
                this.getClass().getName() + " " + query.toString());
        }
        return query;
    }
}
