package ru.yandex.search.messenger.proxy.recents;

import java.util.Collection;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.ps.search.messenger.UserFields;
import ru.yandex.search.messenger.SearchPrivacy;
import ru.yandex.search.messenger.UserId;
import ru.yandex.search.prefix.LongPrefix;

public class ExtractUserDataContext extends ScopeContext {
    private static final String USER_FIELDS =
        UserFields.DATA.stored() + ',' + ru.yandex.ps.search.messenger.UserFields.ID.stored();

    private static final String EXTRACT_USER_DATA_FIELDS =
        USER_FIELDS
            + ',' + UserFields.BLACKLISTED_USERS.stored()
            + ',' + UserFields.HIDDEN_PVP_CHATS.stored()
            + ',' + UserFields.CLEARED_CHATS.stored()
            + ',' + UserFields.SEARCH_PRIVACY.stored();

    private final User user;
    private final Collection<String> users;

    public ExtractUserDataContext(
        final RecentRequestContext context,
        final Set<String> users)
        throws HttpException
    {
        super(context.session(), context);
        this.users = users;
        this.user = new User(context.usersService(), new LongPrefix(0L));
    }

    @Override
    protected User user() {
        return user;
    }

    @Override
    protected String service() {
        return user.service();
    }

    @Override
    protected QueryConstructor createQuery(
        final RecentRequestContext context)
        throws HttpException
    {
        StringBuilder sb = new StringBuilder();
        sb.append("id:");
        UserId.appendId(sb, context.guid(), "0");
        if (users.size() > 0) {
            sb.append(" OR (");
            sb.append("id:(");
            for (String user: users) {
                UserId.appendId(sb, user, "0");
                sb.append(' ');
            }
            sb.setLength(sb.length() - 1);
            sb.append(')');
            sb.append(" AND NOT ");
            sb.append(ru.yandex.ps.search.messenger.UserFields.SEARCH_PRIVACY.global());
            sb.append(':');
            sb.append(SearchPrivacy.NOBODY.value());
            sb.append(" AND NOT ");
            sb.append(ru.yandex.ps.search.messenger.UserFields.IS_ROBOT.global());
            sb.append(":true");
            sb.append(")");
        }

        QueryConstructor query =
            new QueryConstructor(
                "/search?IO_PRIO=0&json-type=dollar");
        query.append("get", EXTRACT_USER_DATA_FIELDS);
        query.append("prefix", "0");
        query.append("service", context.usersService());
        query.append("text",  sb.toString());

        if (context.debug()) {
            context.session().logger().info(this.getClass().getName() + " " + query.toString());
        }
        return query;
    }
}
