package ru.yandex.search.messenger.proxy.recents;

import java.util.concurrent.TimeUnit;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.ps.search.messenger.ChatFields;
import ru.yandex.ps.search.messenger.UserFields;
import ru.yandex.search.prefix.LongPrefix;

public class PvpsFetchContext extends ScopeContext {
    private static final String USER_FIELDS =
        UserFields.DATA.stored() + ',' + ru.yandex.ps.search.messenger.UserFields.ID.stored();

    private static final String PVP_FIELDS =
        ChatFields.MEMBERS.stored() + ','
            + ru.yandex.ps.search.messenger.ChatFields.ID.stored() + ','
            + ChatFields.LAST_MESSAGE_TIMESTAMP.stored() + ','
            + ChatFields.MESSAGE_COUNT.stored() + ','
            + USER_FIELDS;

    private final User user;

    public  PvpsFetchContext(final RecentRequestContext context)
        throws HttpException
    {
        super(context.session(), context);
        if (context.hasV2Org()) {
            user = new User(context.moxy().config().v2ChatsService(), new LongPrefix(context.v2Org()));
        } else {
            user = new User(context.chatsService(), new LongPrefix(0L));
        }
    }

    @Override
    protected User user() {
        return user;
    }

    @Override
    protected String service() {
        return user.service();
    }

    @Override
    protected QueryConstructor createQuery(final RecentRequestContext context)
        throws HttpException
    {
        long curDate =
            TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        QueryConstructor query =
            new QueryConstructor(
                "/search?IO_PRIO=0&json-type=dollar");
        query.append("get", PVP_FIELDS);
        if (context.hasV2Org()) {
            query.append("prefix", context.v2Org());
            query.append("db", "v2org");
            query.append("service", context.moxy().config().v2ChatsService());
            query.append("text",  "chat_members_p:" + context.guid());
        } else  {
            query.append("prefix", "0");
            query.append("service", context.chatsService());
            query.append("text",  "chat_members:" + context.guid());
        }

        query.append("dp", "contains(chat_id,/ slash)");
        query.append("dp", "filter_cmp(slash,!=,1)");
        query.append(
            "dp",
            "replace_all(chat_id,(" + context.guid() + "|_), guid)");
        query.append("dp", "equals(guid,,  empty)");
        query.append("dp", "filter_cmp(empty,==,0)");
        query.append("dp", "const(" + curDate + " cur_date)");
        query.append("dp", "const(0 zero)");
        query.append("dp", "contains(chat_id," + context.guid() + "_ first)");
        query.append("dp", "if(first,chat_first_member_timestamp,chat_second_member_timestamp chat_member_timestamp)");
        query.append("dp", "fallback(chat_member_timestamp,zero last_timestamp)");
        query.append("dp", "cdiv(last_timestamp,1000000 last_timestamp_sec)");
        query.append("dp", "sub(cur_date,last_timestamp_sec sec_passed)");
        query.append("dp", "cdiv(sec_passed,60 minutes_passed)");
        query.append("dp", "csum(minutes_passed,1 age_minutes)");
        query.append("dp", "clog(age_minutes,E time_score)");
        query.append(
            "dp",
            "left_join(guid,user_id,,user_data user_data,user_id user_id,user_is_robot user_is_robot)");
        query.append("postfilter", "user_is_robot != true");
        query.append("sort", "time_score");
        query.append("asc", "true");
        query.append("outer", "deduplicate:chat_members");
        query.append("length", context.length());

        if (context.debug()) {
            context.session().logger().info(this.getClass().getName() + " " + query.toString());
        }
        return query;
    }
}
