package ru.yandex.search.messenger.proxy.recents;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

public class RecentsPrinter
    extends AbstractProxySessionCallback<List<UserInfo>>
{
    private final RecentRequestContext context;

    public RecentsPrinter(
        final RecentRequestContext context)
    {
        super(context.session());
        this.context = context;
    }

    @Override
    public void completed(final List<UserInfo> result) {
        if (result.isEmpty()) {
            context.moxy().emptyRecentResponse();
        }

        if (context.moxy().recentsCache() != null) {
            context.moxy().recentsCache().put(context, result);
        }

        session.connection().setSessionInfo(
            "request_id",
            session.headers().getString(YandexHeaders.X_REQUEST_ID, ""));
        context.session().logger().info("Result size " + result.size());
        session.connection().setSessionInfo(
            SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
            Integer.toString(result.size()));

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("recents");
            writer.value(result);
            writer.endObject();
            session.connection().setSessionInfo(
                "result",
                sbw.toString());
            HttpEntity entity =
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset()));
            session.response(HttpStatus.SC_OK, entity);
        } catch (IOException ioe) {
            failed(ioe);
        }
    }
}
