package ru.yandex.search.messenger.proxy.recents;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;

public abstract class ScopeContext {
    protected RecentRequestContext requestContext;

    public ScopeContext(
        final ProxySession session,
        final RecentRequestContext requestContext)
        throws HttpException
    {
        this.requestContext = requestContext;
    }

    protected abstract User user();

    protected abstract String service();

    protected QueryConstructor query() throws HttpException {
        return createQuery(requestContext);
    }

    protected abstract QueryConstructor createQuery(
        final RecentRequestContext context)
        throws HttpException;
}
