package ru.yandex.search.messenger.proxy.recents;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.json.parser.StackContentHandler;

public final class SimpleJsonParser {
    private final JsonParser parser;
    private final BasicGenericConsumer<JsonObject, JsonException> consumer;

    public SimpleJsonParser() {
        consumer = new BasicGenericConsumer<>();
        parser =
            new JsonParser(new StackContentHandler(
                new TypesafeValueContentHandler(consumer)));
    }

    public JsonObject parse(final String json) throws JsonException {
        parser.parse(json);
        return consumer.get();
    }
}
