package ru.yandex.search.messenger.proxy.recents;

import java.io.IOException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class UserInfo implements JsonValue {
    private final String guid;
    private final JsonMap json;
    private long lastSeen = 0L;

    public UserInfo(final String guid, final JsonMap json) {
        this.guid = guid;
        this.json = json;
    }

    public String guid() {
        return guid;
    }

    public JsonMap json() {
        return json;
    }

    public UserInfo lastSeen(final long lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    public long lastSeen() {
        return lastSeen;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        json.writeValue(writer);
    }
}
