package ru.yandex.search.messenger.proxy.suggest;

import java.util.Map;

public class BasicChatsFilter implements ChatsFilter {
    private Map<String, Long> chatsIds;

    public BasicChatsFilter(final Map<String, Long> chatsIds) {
        this.chatsIds = chatsIds;
    }

    @Override
    public Map<String, Long> chats() {
        return chatsIds;
    }

    @Override
    public boolean testChat(final String chatId) {
        return chatsIds.containsKey(chatId);
    }

    @Override
    public boolean empty() {
        return chatsIds.size() == 0;
    }

    @Override
    public String toString() {
        return "BasicChatsFilter{" +
                   "chatsIds=" + chatsIds +
                   '}';
    }
}
