package ru.yandex.search.messenger.proxy.suggest;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class BasicSuggestItem implements SuggestItem {
    private static final long MILLIS_PER_SEC = 1000;
    private static final long SECS_PER_MONTH = 2678327;

    protected final String id;
    protected final SuggestType type;
    protected final Set<String> requests =
        new HashSet<>(4);
    protected final List<Map.Entry<String, String>> searchTexts;
    protected final double score;
    protected final JsonMap payload;
    protected int hashCode = -1;

    // CSOFF: ParameterNumber
    public BasicSuggestItem(
        final String id,
        final SuggestType type,
        final String request,
        final List<Map.Entry<String, String>> searchTexts,
        final double score,
        final JsonMap payload)
        throws JsonException
    {
        this.id = id;
        this.type = type;
        this.searchTexts = searchTexts;
        this.score = score;
        this.payload = payload;
        requests.add(request);
    }
    // CSON: ParameterNumber

    // CSOFF: ParameterNumber
    public BasicSuggestItem(
        final String id,
        final SuggestType type,
        final Collection<String> requests,
        final List<Map.Entry<String, String>> searchTexts,
        final double score,
        final JsonMap payload)
        throws JsonException
    {
        this.id = id;
        this.type = type;
        this.searchTexts = searchTexts;
        this.score = score;
        this.payload = payload;
        this.requests.addAll(requests);
    }
    // CSON: ParameterNumber

    @Override
    public String id() {
        return id;
    }

    @Override
    public SuggestType type() {
        return type;
    }

    @Override
    public Set<String> requests() {
        return requests;
    }

    @Override
    public void addRequest(final String request) {
        requests.add(request);
    }

    @Override
    public List<Map.Entry<String, String>> searchTexts() {
        return searchTexts;
    }

    @Override
    public double score() {
        return score;
    }

    @Override
    public int compareTo(final SuggestItem other) {
        return Double.compare(other.score(), score());
    }

    @Override
    public int hashCode() {
        if (hashCode == -1) {
            hashCode = id.hashCode()
                + type.hashCode()
                + requests.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof BasicSuggestItem) {
            BasicSuggestItem other = (BasicSuggestItem) o;
            return id.equals(other.id)
                && type == other.type
                && requests.equals(other.requests);
        } else {
            return false;
        }
    }

    @Override
    public JsonMap payload() {
        return payload;
    }

    @Override
    public String toString() {
        return "id: " + id
            + ", type: " + type
            + ", requests: " + requests
            + ", searchTexts: " + searchTexts
            + ", payload: " + payload;
    }

    public static double scoreByMessageMicroTs(final double micorts) {
        return scoreByMessageTs(micorts / 1000.0);
    }

    public static double scoreByMessageTs(final double millsts) {
        double diff = (System.currentTimeMillis() - millsts) / 1000.0;
        if (diff <= 0) {
            diff = 1;
        }
        return
            2 * Math.log((double) SECS_PER_MONTH * 2.0) / Math.log(diff);
    }
}

