package ru.yandex.search.messenger.proxy.suggest;

import java.util.Set;

public class BasicUsersFilter implements UsersFilter {
    private Set<String> userIds;

    public BasicUsersFilter(final Set<String> userIds) {
        this.userIds = userIds;
    }

    @Override
    public Set<String> users() {
        return userIds;
    }

    @Override
    public boolean testUser(final String userId) {
        return userIds.contains(userId);
    }

    @Override
    public boolean empty() {
        return userIds.size() == 0;
    }

    @Override
    public String toString() {
        return "BasicUsersFilter{" +
            "size=" + users().size() + "    userIds=" + userIds +
            '}';
    }
}
