package ru.yandex.search.messenger.proxy.suggest;

import java.util.Map;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;

public class MetaStoringUsersFilter implements MetaHandlingUsersFilter {
    private Map<String, JsonMap> users;

    public MetaStoringUsersFilter(final Map<String, JsonMap> usersMeta) {
        this.users = usersMeta;
    }

    @Override
    public Set<String> users() {
        return users.keySet();
    }

    @Override
    public boolean testUser(final String userId) {
        return users.containsKey(userId);
    }

    @Override
    public boolean empty() {
        return users.size() == 0;
    }

    @Override
    public void feedMeta(final String userId, final JsonMap doc) {
        JsonMap meta = users.get(userId);
        if (meta != null) {
            doc.putAll(meta);
        }
    }
}
