package ru.yandex.search.messenger.proxy.suggest;

import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;

public interface SuggestItem extends Comparable<SuggestItem> {
    // Some unique id which allows to deduplicate items came from different
    // suggest rules
    String id();

    // Suggest type
    SuggestType type();

    // Suggest request, may differ from original request because of
    // preprocessing, transliteration etc.
    Set<String> requests();

    void addRequest(final String request);

    // Suggest text, which should be displayed and highlighted with request
    List<Map.Entry<String, String>> searchTexts();

    double score();

    // Additional data, like file id or mimetype. May be empty for some suggest
    // types, like history
    JsonMap payload();
}

