package ru.yandex.search.messenger.proxy.suggest;

import java.util.Set;
import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.messenger.proxy.Moxy;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public interface SuggestRequestContext
    extends UniversalSearchProxyRequestContext
{
    Moxy proxy();

    ProxySession session();

    Supplier<? extends HttpClientContext> contextGenerator();

    Set<Set<SuggestType>> typeGroups();

    Set<SuggestType> types();

    int length();

    Long timeout();

    JsonType jsonType();

    Set<String> namespaces();

    @Override
    AsyncClient client();

    boolean hadRequest(SuggestType type, String request);

    default boolean debug() {
        return false;
    }

    Set<String> namespacesGuids();

    Long v2Org();
}

