package ru.yandex.search.messenger.proxy.suggest;

import java.util.List;
import java.util.Map;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class UserSuggestItem extends BasicSuggestItem {
    private static final long MILLIS_PER_SEC = 1000;
    private static final long SECS_PER_MONTH = 2678327;
    protected final double scoreDiff;
    protected final long lastMsgTs;

    // CSOFF: ParameterNumber
    public UserSuggestItem(
        final String id,
        final SuggestType type,
        final String request,
        final List<Map.Entry<String, String>> searchTexts,
        final double score,
        final JsonMap payload,
        final long lastMsgTs)
        throws JsonException
    {
        super(id, type, request, searchTexts, score, payload);
        this.lastMsgTs = lastMsgTs;
        if (lastMsgTs != 0) {
            scoreDiff = scoreByMessageTs(lastMsgTs);
        } else {
            scoreDiff = 0;
        }
    }
    // CSON: ParameterNumber

    @Override
    public double score() {
        return score + scoreDiff;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return super.equals(o);
    }

    @Override
    public String toString() {
        return "(user) id: " + id
            + ", type: " + type
            + ", scoreDiff: " + scoreDiff
            + ", score: " + score
            + ", scoreTotal: " + (score + scoreDiff)
            + ", lastMsgTs: " + lastMsgTs
            + ", requests: " + requests
            + ", searchTexts: " + searchTexts
            + ", payload: " + payload;
    }
}

