package ru.yandex.search.messenger.proxy.suggest.rules;

import java.util.Collection;
import java.util.function.Function;

import ru.yandex.function.IteratorSupplierAdapter;
import ru.yandex.search.request.util.BoostByOrderFieldsTermsSupplier;

public class BoostByOrderFieldsSwitchingTermsSupplierFactory
    implements Function<String, BoostByOrderFieldsTermsSupplier>
{
    private final Collection<String> tokenizedFields;
    private final Collection<String> keywordFields;
    private final float initialBoost;
    private final float keywordBoost;

    //CSOFF: ParameterNumber
    public BoostByOrderFieldsSwitchingTermsSupplierFactory(
        final float initialBoost,
        final float keywordBoost,
        final Collection<String> tokenizedFields,
        final Collection<String> keywordFields)
    {
        this.initialBoost = initialBoost;
        this.keywordBoost = keywordBoost;
        this.tokenizedFields = tokenizedFields;
        this.keywordFields = keywordFields;
    }
    //CSON: ParameterNumber

    @Override
    public BoostByOrderFieldsTermsSupplier apply(final String token) {
        Collection<String> fields;
        boolean nonAlphaNum = false;
        int lastChar = token.length() - 1;
        for (int i = 0; i < token.length(); i++) {
            char c = token.charAt(i);
            if (!Character.isLetterOrDigit(c)
                && !(c == '*' && i == lastChar))
            {
                nonAlphaNum = true;
                break;
            }
        }
        float boost;
        if (nonAlphaNum) {
            boost = initialBoost;
            fields = keywordFields;
        } else {
            boost = keywordBoost;
            fields = tokenizedFields;
        }
        return new BoostByOrderFieldsTermsSupplier(
            new IteratorSupplierAdapter<>(fields.iterator()),
            token,
            boost,
            0f);
    }
}
